package ru.yandex.travel.hotels.common.partners.expedia.model.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.content.LocalizedLinks;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Address.AddressBuilder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Address {
    @JsonProperty("line_1")
    private String line1;
    @JsonProperty("line_2")
    private String line2;
    @JsonProperty("line_3")
    private String line3;
    private String city;
    private String stateProvinceCode;
    private String stateProvinceName;
    private String postalCode;
    private String countryCode;
    private Boolean obfuscationRequired;
    private LocalizedLinks localized;

    @JsonPOJOBuilder(withPrefix = "")
    public static class AddressBuilder {
    }
}
