package ru.yandex.travel.hotels.common.partners.expedia.model.common;

import java.math.BigDecimal;
import java.time.Instant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = CancelPenalty.CancelPenaltyBuilder.class)
public class CancelPenalty {
    private String currency;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "UTC")
    private Instant start;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "UTC")
    private Instant end;
    private BigDecimal amount;
    private Integer nights;
    private BigDecimal percent;

    @JsonPOJOBuilder(withPrefix = "")
    public static class CancelPenaltyBuilder {
        @JsonDeserialize(using = Deserializers.PercentStringToDecimalDeserializer.class)
        private BigDecimal percent;

    }
}
