package ru.yandex.travel.hotels.common.partners.expedia.model.common;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Error.ErrorBuilder.class)
public class Error {
    public static final String DUPLICATE_ITINERARY = "duplicate_itinerary";
    public static final String PRICE_MISMATCH = "price_mismatch";
    public static final String ROOMS_UNAVAILABLE = "rooms_unavailable";
    public static final String INVALID_INPUT = "invalid_input";


    private String type;
    private String message;
    private List<ErrorField> fields;
    private List<Error> errors;


    @JsonPOJOBuilder(withPrefix = "")
    public static class ErrorBuilder {
    }
}
