package ru.yandex.travel.hotels.common.partners.expedia.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Frequency {
    PER_NIGHT("per_night"),
    PER_DAY("per_day"),
    PER_STAY("per_stay"),
    PER_WEEK("per_week"),
    ROUND_TRIP("round_trip"),
    ONE_WAY("one_way"),
    UNKNOWN("unknown");

    private final String value;

    Frequency(String value) {
        this.value = value;
    }

    @JsonCreator
    public static Frequency fromString(String value) {
        for (var candidate : Frequency.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown Frequency %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
