package ru.yandex.travel.hotels.common.partners.expedia.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum LegacyFeeType {
    MANDATORY_FEE("mandatory_fee"),
    RESORT_FEE("resort_fee"),
    MANDATORY_TAX("mandatory_tax");

    private final String value;

    LegacyFeeType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static LegacyFeeType fromString(String value) {
        for (var candidate : LegacyFeeType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown LegacyFeeType %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
