package ru.yandex.travel.hotels.common.partners.expedia.model.common;

import java.time.Instant;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Link.LinkBuilder.class)
public class Link {
    private String method;
    private String href;
    private Instant expires;

    @JsonPOJOBuilder(withPrefix = "")
    public static class LinkBuilder {
    }
}
