package ru.yandex.travel.hotels.common.partners.expedia.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum MerchantOfRecord {
    EXPEDIA("expedia"),
    PROPERTY("property");

    private final String value;

    MerchantOfRecord(String value) {
        this.value = value;
    }

    @JsonCreator
    public static MerchantOfRecord fromString(String value) {
        for (var candidate : MerchantOfRecord.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown MerchantOfRecord %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
