package ru.yandex.travel.hotels.common.partners.expedia.model.common;

import java.math.BigDecimal;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.shopping.PriceItemType;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PriceItem.PriceItemBuilder.class)
public class PriceItem {
    private PriceItemType type;
    private BigDecimal value;
    private String currency;


    @JsonPOJOBuilder(withPrefix = "")
    public static class PriceItemBuilder {
    }
}
