package ru.yandex.travel.hotels.common.partners.expedia.model.common;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.shopping.Fees;
import ru.yandex.travel.hotels.common.partners.expedia.model.shopping.Totals;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PricingInformation.PricingInformationBuilder.class)
public class PricingInformation {
    @Singular(value = "night")
    private List<List<PriceItem>> nightly;
    @Singular(value = "stayItem")
    private List<PriceItem> stay;
    private Totals totals;
    private Fees fees;


    @JsonPOJOBuilder(withPrefix = "")
    public static class PricingInformationBuilder {
        @JsonDeserialize(using = Deserializers.FeesDeserializer.class)
        private Fees fees;
    }
}
