package ru.yandex.travel.hotels.common.partners.expedia.model.content;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.BedConfiguration;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = BedGroup.BedGroupBuilder.class)
public class BedGroup {
    private String id;
    private String description;
    private List<BedConfiguration> configuration;

    @JsonPOJOBuilder(withPrefix = "")
    public static class BedGroupBuilder {
    }
}
