package ru.yandex.travel.hotels.common.partners.expedia.model.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Checkin.CheckinBuilder.class)
public class Checkin {
    private String is24Hour;
    private String beginTime;
    private String endTime;
    private String instructions;
    private String specialInstructions;
    private Integer minAge;


    @JsonPOJOBuilder(withPrefix = "")
    public static class CheckinBuilder {
        @JsonProperty("24_hour")
        private String is24Hour;
    }
}
