package ru.yandex.travel.hotels.common.partners.expedia.model.content;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Descriptions.DescriptionsBuilder.class)
public class Descriptions {
    private String amenities;
    private String dining;
    private String renovations;
    private String nationalRatings;
    private String businessAmenities;
    private String rooms;
    private String attractions;
    private String location;
    private String headline;

    @JsonPOJOBuilder(withPrefix = "")
    public static class DescriptionsBuilder {
    }
}
