package ru.yandex.travel.hotels.common.partners.expedia.model.content;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = GuestRating.GuestRatingBuilder.class)
public class GuestRating {
    private int count;
    private double overall;
    private double cleanliness;
    private double service;
    private double comfort;
    private double condition;
    private double location;
    private double neighborhood;
    private double quality;
    private double value;
    private double amenities;
    private double recommendationPercent;


    @JsonPOJOBuilder(withPrefix = "")
    public static class GuestRatingBuilder {
    }
}
