package ru.yandex.travel.hotels.common.partners.expedia.model.content;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.Address;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.IdNameValue;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PropertyContent.PropertyContentBuilder.class)
public class PropertyContent {
    private String propertyId;
    private String name;
    private Address address;
    private Ratings ratings;
    private Location location;
    private String phone;
    private String fax;
    private IdNameValue category;
    private BusinessModel businessModel;
    private Long rank;
    private Checkin checkin;
    private Checkout checkout;
    private Fees fees;
    private Policies policies;
    private Attributes attributes;
    private Map<String, IdNameValue> amenities;
    private List<ExpediaImage> images;
    private OnsitePayments onsitePayments;
    private Map<String, RoomContent> rooms;
    private Map<String, RateContent> rates;
    private Dates dates;
    private Descriptions descriptions;
    private Map<String, IdNameValue> statistics;
    private Airports airports;
    private String registryNumber;
    private Map<String, IdNameValue> themes;
    private AllInclusiveInfo allInclusive;
    private String taxId;
    private Chain chain;
    private IdNameValue brand;
    private Map<String, IdNameValue> spokenLanguages;
    private boolean multiUnit;
    private boolean paymentRegistrationRecommended;


    @JsonPOJOBuilder(withPrefix = "")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class PropertyContentBuilder {
    }


}
