package ru.yandex.travel.hotels.common.partners.expedia.model.content;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PropertyRatingType {
    STAR("Star"),
    ALTERNATE("Alternate");

    private final String value;

    PropertyRatingType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static PropertyRatingType fromString(String value) {
        for (var candidate : PropertyRatingType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown PropertyRatingType %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
