package ru.yandex.travel.hotels.common.partners.expedia.model.content;

import java.util.Map;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.IdNameValue;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RateContent.RateContentBuilder.class)
public class RateContent {
    private String id;
    private Map<String, IdNameValue> amenities;
    private String specialOfferDescription;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RateContentBuilder {
    }
}
