package ru.yandex.travel.hotels.common.partners.expedia.model.content;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.IdNameValue;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomContent.RoomContentBuilder.class)
public class RoomContent {
    private String id;
    private String name;
    private RoomDescription descriptions;
    private Map<String, IdNameValue> amenities;
    private List<ExpediaImage> images;
    private Map<String, BedGroup> bedGroups;
    private Area area;
    private Map<String, IdNameValue> views;
    private RoomOccupancy occupancy;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomContentBuilder {
    }
}
