package ru.yandex.travel.hotels.common.partners.expedia.model.content;

import java.util.Map;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomOccupancy.RoomOccupancyBuilder.class)
public class RoomOccupancy {
    private RoomOccupancyMaxAllowed maxAllowed;
    private Map<String, AgeCategory> ageCategories;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomOccupancyBuilder {
    }
}
