package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.Frequency;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.ValueWithCurrency;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Fee.FeeBuilder.class)
public class Fee {
    private ValueWithCurrency billableCurrency;
    private ValueWithCurrency requestCurrency;
    private FeeScope scope;  // 2.4 only
    private Frequency frequency; // 2.4 only

    @JsonPOJOBuilder(withPrefix = "")
    public static class FeeBuilder {
    }
}
