package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum FeeScope {
    PER_PERSON("per_person"),
    PER_ROOM("per_room"),
    PER_ACCOMMODATION("per_accommodation"),
    PER_HOUSE("per_house"),
    PER_APARTMENT("per_apartment"),
    PER_ADULT("per_adult"),
    UNKNOWN("unknown");


    private final String value;

    FeeScope(String value) {
        this.value = value;
    }

    @JsonCreator
    public static FeeScope fromString(String value) {
        for (var candidate : FeeScope.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown FeeScope %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
