package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.Frequency;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.LegacyFee;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.ValueWithCurrency;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Fees.FeesBuilder.class)
public class Fees {
    private Fee mandatoryFee;
    private Fee resortFee;
    private Fee mandatoryTax;

    @JsonPOJOBuilder(withPrefix = "")
    public static class FeesBuilder {
    }

    public static Fees fromLegacyList(List<LegacyFee> legacyFees) {
        var builder = Fees.builder();
        for (LegacyFee fee : legacyFees) {
            Fee convertedFee = Fee.builder()
                    .billableCurrency(ValueWithCurrency.builder()
                            .value(fee.getValue())
                            .currency(fee.getCurrency())
                            .build())
                    .build();
            switch (fee.getType()) {
                case RESORT_FEE:
                    builder.resortFee(convertedFee);
                    break;
                case MANDATORY_FEE:
                    builder.mandatoryFee(convertedFee);
                    break;
                case MANDATORY_TAX:
                    builder.mandatoryTax(convertedFee);
                    break;
            }
        }
        return builder.build();
    }
}
