package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.Link;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PriceCheckLinks.PriceCheckLinksBuilder.class)
public class PriceCheckLinks {
    private Link book;
    private Link paymentSession;
    private Link additionalRates;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PriceCheckLinksBuilder {
    }
}
