package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PriceItemType {
    BASE_RATE("base_rate"),
    TAX_AND_SERVICE_FEE("tax_and_service_fee"),
    EXTRA_PERSON_FEE("extra_person_fee"),
    COMPENSATION("compensation"),
    PROPERTY_FEE("property_fee"),
    SALES_TAX("sales_tax"),
    ADJUSTMENT("adjustment"),
    RECOVERY_CHARGES_AND_FEES("recovery_charges_and_fees");

    private final String value;

    PriceItemType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static PriceItemType fromString(String value) {
        for (var candidate : PriceItemType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown PriceBreakoutType %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
