package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PropertyAvailability.PropertyAvailabilityBuilder.class)
public class PropertyAvailability {
    private String propertyId;
    private List<RoomAvailability> rooms;
    private ShoppingLinks links;
    private Double score;



    @JsonPOJOBuilder(withPrefix = "")
    public static class PropertyAvailabilityBuilder {
    }
}
