package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomAvailability.RoomAvailabilityBuilder.class)
public class RoomAvailability {
    private String id;
    private String roomName;
    private List<ShoppingRate> rates;


    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomAvailabilityBuilder {
    }
}
