package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.PricingInformation;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomPriceCheck.RoomPriceCheckBuilder.class)
public class RoomPriceCheck {
    private ShoppingRateStatus status;
    private Map<String, PricingInformation> occupancyPricing;
    private PriceCheckLinks links;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomPriceCheckBuilder {
    }
}
