package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = SaleScenario.SaleScenarioBuilder.class)
public class SaleScenario {
    @JsonProperty("package")
    private boolean packageDeal;
    @JsonProperty("member")
    private boolean memberDeal;
    @JsonProperty("corporate")
    private boolean corporateDeal;
    @JsonProperty("distribution")
    private boolean distributionDeal;

    @JsonPOJOBuilder(withPrefix = "")
    public static class SaleScenarioBuilder {
    }
}
