package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SalesChannel {
    WEBSITE("website"),
    AGENT_TOOL("agent_tool"),
    MOBILE_APP("mobile_app"),
    MOBILE_WEB("mobile_web"),
    META("meta"),
    CACHE("cache");

    private final String value;

    SalesChannel(String value) {
        this.value = value;
    }

    @JsonCreator
    public static SalesChannel fromString(String value) {
        for (var candidate : SalesChannel.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown SalesChannel %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public boolean isMobile() {
        return this == MOBILE_APP || this == MOBILE_WEB;
    }
}
