package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.BedConfiguration;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.StringIdEntity;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ShoppingBedGroup.ShoppingBedGroupBuilder.class)
public class ShoppingBedGroup implements StringIdEntity {
    private String id;
    private String description;
    private List<BedConfiguration> configuration;
    private ShoppingBedGroupLinks links;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ShoppingBedGroupBuilder {
    }
}
