package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.CancelPenalty;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.Deserializers;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.IdNameValue;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.MerchantOfRecord;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.PricingInformation;
import ru.yandex.travel.hotels.common.partners.expedia.model.common.Promotions;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ShoppingRate.ShoppingRateBuilder.class)
public class ShoppingRate {
    private String id;
    private String propertyId;
    private String roomId;
    private LocalDate checkin;
    private LocalDate checkout;
    private ShoppingRateStatus status;
    private int availableRooms;
    private boolean refundable;
    private Boolean memberDealAvailable;
    private SaleScenario saleScenario;
    private boolean depositRequired;            // 2.4 only
    private MerchantOfRecord merchantOfRecord;
    private Map<String, IdNameValue> amenities;
    private ShoppingRateLinks links;
    private Map<String, ShoppingBedGroup> bedGroups;
    private List<CancelPenalty> cancelPenalties;
    private Map<String, PricingInformation> occupancyPricing;
    private Promotions promotions;


    @JsonIgnore
    public boolean hasSomeFencedDeal() {
        return saleScenario != null && saleScenario.isMemberDeal();
    }


    @JsonPOJOBuilder(withPrefix = "")
    public static class ShoppingRateBuilder {
        @JsonDeserialize(using = Deserializers.ListToMapDeserializer.class)
        private Map<String, IdNameValue> amenities;
        @JsonDeserialize(using = Deserializers.ListToMapDeserializer.class)
        private Map<String, ShoppingBedGroup> bedGroups;
    }
}
