package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ShoppingRateStatus {
    AVAILABLE("available"),
    PRICE_CHANGED("price_changed"),
    SOLD_OUT("sold_out");

    private final String value;

    ShoppingRateStatus(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ShoppingRateStatus fromString(String value) {
        for (var candidate : ShoppingRateStatus.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown ShoppingRateStatus %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
