package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Totals.TotalsBuilder.class)
public class Totals {
    private TotalsItem inclusive;
    private TotalsItem exclusive;
    private TotalsItem strikethrough;
    private TotalsItem marketingFee;
    private TotalsItem grossProfit;
    private TotalsItem minimumSellingPrice;
    private TotalsItem propertyFees;


    @JsonPOJOBuilder(withPrefix = "")
    public static class TotalsBuilder {
    }
}
