package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.Frequency;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ValueAdd.ValueAddBuilder.class)
public class ValueAdd {
    private String id;
    private String description;
    private ValueAddCategory category;
    private ValueAddOfferType offerType;
    private Frequency frequency;
    private Integer personCount;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ValueAddBuilder {
    }
}
