package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ValueAddCategory {
    FOOD_AND_BEVERAGE("food_and_beverage"),
    ENTERTAINMENT("entertainment"),
    SERVICE("service"),
    ACTIVITY("activity"),
    CREDIT("credit");


    private final String value;

    ValueAddCategory(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ValueAddCategory fromString(String value) {
        for (var candidate : ValueAddCategory.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown ValueAddCategory %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
