package ru.yandex.travel.hotels.common.partners.expedia.model.shopping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ValueAddOfferType {
    BUY_ONE_GET_ONE_FREE("buy_one_get_one_free"),
    CREDIT("credit"),
    DISCOUNT("discount"),
    FREE("free"),
    VOUCHER("voucher");

    private final String value;

    ValueAddOfferType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ValueAddOfferType fromString(String value) {
        for (var candidate : ValueAddOfferType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown ValueAddOfferType %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
