package ru.yandex.travel.hotels.common.partners.travelline;

import java.time.LocalDate;
import java.util.concurrent.CompletableFuture;

import org.javamoney.moneta.Money;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.travelline.model.CancelReservationResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.ConfirmReservationResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelChainDetailsResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelDetailsResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelInfo;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelInventoryResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelOfferAvailability;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelReservationRequest;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelReservationResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelStatusChangedResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.ListHotelsResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.MakeExtraPaymentResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.ReadReservationResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.VerifyReservationRequest;
import ru.yandex.travel.hotels.common.partners.travelline.model.VerifyReservationResponse;

import static ru.yandex.travel.hotels.common.partners.base.Helpers.sync;

public interface TravellineClient {

    CompletableFuture<HotelInfo> getHotelInfo(String hotelCode, String requestId);

    CompletableFuture<HotelOfferAvailability> findOfferAvailability(String hotelCode,
                                                                    LocalDate checkinDate,
                                                                    LocalDate checkoutDate,
                                                                    String requestId);

    CompletableFuture<VerifyReservationResponse> verifyReservation(VerifyReservationRequest request);

    CompletableFuture<HotelReservationResponse> createReservation(HotelReservationRequest request);

    CompletableFuture<ConfirmReservationResponse> confirmReservation(String yandexNumber,
                                                                     String transactionNumber, Money amount);

    CompletableFuture<MakeExtraPaymentResponse> makeExtraPayment(String yandexNumber,
                                                                 String transactionNumber, Money amount);

    CompletableFuture<CancelReservationResponse> cancelReservation(String yandexNumber);

    CompletableFuture<ReadReservationResponse> readReservation(String yandexNumber);

    CompletableFuture<HotelInventoryResponse> getHotelInventory(String hotelCode);

    CompletableFuture<ListHotelsResponse> listHotels();

    CompletableFuture<HotelStatusChangedResponse> notifyHotelStatusChanged(String hotelCode);

    CompletableFuture<HotelDetailsResponse> getHotelDetails(String hotelCode);

    CompletableFuture<HotelChainDetailsResponse> getHotelChainDetails(String inn);

    default TravellineClient withCallContext(CallContext callContext) {
        return new CallContextTravellineClient(this, callContext);
    }

    default CompletableFuture<HotelInfo> getHotelInfo(String hotelCode) {
        return getHotelInfo(hotelCode, null);
    }

    default HotelInfo getHotelInfoSync(String hotelCode) {
        return sync(getHotelInfo(hotelCode));
    }

    default HotelInfo getHotelInfoSync(String hotelCode, String requestId) {
        return sync(getHotelInfo(hotelCode, requestId));
    }

    default CompletableFuture<HotelOfferAvailability> findOfferAvailability(String hotelCode,
                                                                            LocalDate checkinDate,
                                                                            LocalDate checkoutDate) {
        return findOfferAvailability(hotelCode, checkinDate, checkoutDate, null);
    }

    default HotelOfferAvailability findOfferAvailabilitySync(String hotelCode, LocalDate checkinDate,
                                                             LocalDate checkoutDate) {
        return sync(findOfferAvailability(hotelCode, checkinDate, checkoutDate));
    }

    default VerifyReservationResponse verifyReservationSync(VerifyReservationRequest request) {
        return sync(verifyReservation(request));
    }

    default HotelReservationResponse createReservationSync(HotelReservationRequest request) {
        return sync(createReservation(request));
    }

    default ConfirmReservationResponse confirmReservationSync(String yandexNumber, String transactionNumber,
                                                              Money amount) {
        return sync(confirmReservation(yandexNumber, transactionNumber, amount));
    }

    default MakeExtraPaymentResponse makeExtraPaymentSync(String yandexNumber, String transactionNumber, Money amount) {
        return sync(makeExtraPayment(yandexNumber, transactionNumber, amount));
    }

    default CancelReservationResponse cancelReservationSync(String yandexNumber) {
        return sync(cancelReservation(yandexNumber));
    }

    default ReadReservationResponse readReservationSync(String yandexNumber) {
        return sync(readReservation(yandexNumber));
    }

    default HotelInventoryResponse getHotelInventorySync(String hotelCode) {
        return sync(getHotelInventory(hotelCode));
    }

    default ListHotelsResponse listHotelsSync() {
        return sync(listHotels());
    }


    default HotelStatusChangedResponse notifyHotelStatusChangedSync(String hotelCode) {
        return sync(notifyHotelStatusChanged(hotelCode));
    }

    default HotelDetailsResponse getHotelDetailsSync(String hotelCode) {
        return sync(getHotelDetails(hotelCode));
    }

    default HotelChainDetailsResponse getHotelChainDetailsSync(String inn) {
        return sync(getHotelChainDetails(inn));
    }
}
