package ru.yandex.travel.hotels.common.partners.travelline.exceptions;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.Getter;

import ru.yandex.travel.hotels.common.partners.base.exceptions.PartnerException;
import ru.yandex.travel.hotels.common.partners.travelline.model.Error;
import ru.yandex.travel.hotels.common.partners.travelline.model.ErrorType;

public class ReturnedErrorException extends PartnerException {
    @Getter
    private final List<Error> errors;

    public ReturnedErrorException(List<Error> errors) {
        super("Partner returned error(s): " + errors.stream().map(Error::toString)
                .collect(Collectors.joining(", ")));
        this.errors = errors;
    }

    public Error getErrorOfType(ErrorType... type) {
        Set<ErrorType> typesToSearch = Set.of(type);
        return errors.stream().filter(e -> typesToSearch.contains(e.getErrorCode())).findAny().orElse(null);
    }
}
