package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Address.AddressBuilder.class)
public class Address {

    private String postalCode;

    private String countryCode;

    private String region;

    private String county;

    private String cityName;

    private List<String> addressLine;

    private double latitude;

    private double longitude;

    private String remark;

    @JsonPOJOBuilder(withPrefix = "")
    public static class AddressBuilder {
    }
}
