package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Amenity.AmenityBuilder.class)
public class Amenity {

    private String kind;

    private String name;

    @JsonPOJOBuilder(withPrefix = "")
    public static class AmenityBuilder {
    }
}
