package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BookingMode {
    CALCULATE_ADULTS_SEPARATELY_FROM_CHILDREN("calculate-adults-separately-from-children");
    private final String value;

    BookingMode(String value) {
        this.value = value;
    }

    @JsonCreator
    public static BookingMode fromString(String value) {
        for (var candidate : BookingMode.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown BookingMode %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
