package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BookingStatus {
    PENDING("pending"),
    CONFIRMED("confirmed"),
    UNCONFIRMED("unconfirmed"),
    CANCELLED("cancelled");

    private String value;

    BookingStatus(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static BookingStatus fromString(String value) {
        for (BookingStatus candidate : BookingStatus.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown booking status %s", value)
        );
    }
}
