package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum CancelPenaltyBasis {
    NIGHTS("nights"),
    FIRST_NIGHT("first_night"),
    PREPAYMENT("prepayment"),
    FULL_STAY("full_stay");

    private String value;

    CancelPenaltyBasis(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static CancelPenaltyBasis fromString(String value) {
        for (CancelPenaltyBasis candidate : CancelPenaltyBasis.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown cancel penalty basis %s", value)
        );
    }
}
