package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = CancelPenaltyGroup.CancelPenaltyGroupBuilder.class)
public class CancelPenaltyGroup {

    private boolean freeCancellation;

    @Singular
    private List<CancelPenalty> cancelPenalties;

    @JsonPOJOBuilder(withPrefix = "")
    public static class CancelPenaltyGroupBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = CancelPenalty.CancelPenaltyBuilder.class)
    public static class CancelPenalty {

        private LocalDateTime start;

        private LocalDateTime end;

        private CancelPenaltyBasis basis;

        private Integer nights;

        private Double percent;

        private Double amount;

        private Currency currency;

        @JsonPOJOBuilder(withPrefix = "")
        public static class CancelPenaltyBuilder {
        }
    }
}
