package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = CancelReservationRequest.CancelReservationRequestBuilder.class)
public class CancelReservationRequest {
    private String yandexNumber;
    @Singular
    private List<CancellationReason> reasons;

    @JsonPOJOBuilder(withPrefix = "")
    public static class CancelReservationRequestBuilder {

    }
}
