package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.time.LocalDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = CancellationInfo.CancellationInfoBuilder.class)
public class CancellationInfo {

    private LocalDateTime cancellationDate;

    private String cancellationMessage;

    private Penalty penalty;

    @JsonPOJOBuilder(withPrefix = "")
    public static class CancellationInfoBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Penalty.PenaltyBuilder.class)
    public static class Penalty {

        private Double priceBeforeTax;

        private Currency currency;

        @JsonPOJOBuilder(withPrefix = "")
        public static class PenaltyBuilder {
        }
    }
}
