package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum CancellationReason {
    CANCELLATION_TRAVEL("cancellation_travel"),
    CHANGE_HOTEL("change_hotel"),
    AMMENDMENT_ARRIVAL_DATE("ammendment_arrival_date"),
    CHANGE_ROOM_TYPE("change_room_type"),
    CHANGE_PAYMENT_METHOD("change_payment_method"),
    NO_SHOW("no_show"),
    CANCEL_BOOKING("cancel_booking"),
    INVALID_CARD_DETAILS("invalid_card_details"),
    CUSTOM("custom");

    private String value;

    CancellationReason(String value) {
        this.value = value;
    }

    @JsonCreator
    public static CancellationReason fromString(String value) {
        for (CancellationReason candidate : CancellationReason.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown cancellation reason %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
