package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ChargeType {

    PER_RESERVATION("per_reservation"),
    PER_STAY("per_stay"),
    PER_PERSON("per_person"),
    PER_ROOM_PER_NIGHT("per_room_per_night"),
    PER_PERSON_PER_NIGHT("per_person_per_night"),
    PER_UNIT("per_unit"),
    PER_OCCUPANCY_PER_NIGHT("per_occupancy_per_night");

    private String value;

    ChargeType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static ChargeType fromString(String value) {
        for (ChargeType candidate : ChargeType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown charge type %s", value)
        );
    }
}
