package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ConfirmReservationOrExtraPaymentRequest.ConfirmReservationRequestBuilder.class)
public class ConfirmReservationOrExtraPaymentRequest {
    private String yandexNumber;
    private Guarantee guarantee;

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Guarantee.GuaranteeBuilder.class)
    public static class Guarantee {
        private String transactionId;
        private Double paymentAmount;
        private String paymentCurrency;

        @JsonPOJOBuilder(withPrefix = "")
        public static class GuaranteeBuilder {
        }
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class ConfirmReservationRequestBuilder {
    }
}
