package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ContactInfo.ContactInfoBuilder.class)
public class ContactInfo {
    @Singular
    private List<Address> addresses;

    @Singular
    private List<Phone> phones;

    @Singular
    private List<Email> emails;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ContactInfoBuilder {
    }
}
