package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ContactType {
    CONTRACT("contract"),
    RESERVATION("reservation"),
    OFFER("offer"),
    ACCOUNTANT("accountant");


    private String code;

    ContactType(String code) {
        this.code = code;
    }

    @JsonCreator
    public static ContactType fromString(String value) {
        for (ContactType candidate : ContactType.values()) {
            if (candidate.code != null && candidate.code.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown contact type %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return code;
    }
}
